<?php

namespace Meetanshi\SubCategoriesGridList\Helper;

use \Magento\Framework\App\Helper\Context;
use \Magento\Store\Model\ScopeInterface;
use \Magento\Framework\App\Config\ScopeConfigInterface;
use \Magento\Framework\App\Helper\AbstractHelper;

class Data extends AbstractHelper
{

    const SORTBY = 'subcategoriesgridlist/category/category_sortby';
    const ORDERBY = 'subcategoriesgridlist/category/category_orderby';
    const COLUMNCOUNT = 'subcategoriesgridlist/category/category_per_row';
    const LAYOUT = 'subcategoriesgridlist/category/category_layout';
    const BLOCLTITLE = 'subcategoriesgridlist/category/category_block_title';
    const CATEGORY_DESC = 'subcategoriesgridlist/category/category_showdesc';
    const CATEGORY_LOCATION = 'subcategoriesgridlist/category/category_listlocation';
    const CATEGORY_ENABLE = 'subcategoriesgridlist/category/category_enable';
    const EXTENSION_ENABLE = 'subcategoriesgridlist/general/enable';

    protected $scopeConfig;

    public function __construct(Context $context, ScopeConfigInterface $scopeConfig)
    {
        parent::__construct($context);
        $this->scopeConfig = $scopeConfig;
    }

    public function getConfig($config_path)
    {
        return $this->scopeConfig->getValue($config_path, ScopeInterface::SCOPE_STORE);
    }

    public function getSortBy()
    {
        return $this->scopeConfig->getValue(self::SORTBY, ScopeInterface::SCOPE_STORE);
    }

    public function getOrderBy()
    {
        return $this->scopeConfig->getValue(self::ORDERBY, ScopeInterface::SCOPE_STORE);
    }

    public function getColumnCount()
    {
        return $this->scopeConfig->getValue(self::COLUMNCOUNT, ScopeInterface::SCOPE_STORE);
    }

    public function getLayout()
    {
        return $this->scopeConfig->getValue(self::LAYOUT, ScopeInterface::SCOPE_STORE);
    }

    public function getBlockTitle()
    {
        return $this->scopeConfig->getValue(self::BLOCLTITLE, ScopeInterface::SCOPE_STORE);
    }

    public function getCategoryDesc()
    {
        return $this->scopeConfig->getValue(self::CATEGORY_DESC, ScopeInterface::SCOPE_STORE);
    }

    public function getDisplayLocation()
    {
        return $this->scopeConfig->getValue(self::CATEGORY_LOCATION, ScopeInterface::SCOPE_STORE);
    }

    public function getCategoryEnable()
    {
        return $this->scopeConfig->getValue(self::CATEGORY_ENABLE, ScopeInterface::SCOPE_STORE);
    }

    public function getExtensionEnable()
    {
        return $this->scopeConfig->getValue(self::EXTENSION_ENABLE, ScopeInterface::SCOPE_STORE);
    }
}
