
# How To Contribute

Community made patches,  bug reports and contributions are always welcome for Paystack plugins and libraries. 

When contributing please ensure you follow the guidelines below to help us keep on top of things.

__Please Note:__

GitHub is for _bug reports and contributions only_ - if you have a support question or a request for a customization this is not the right place to post it.  Please reach out by 

- sending a message from [our website](https://paystack.com/contact).
- posting a question on the plugin support forum.

## Contributing to Plugin

### Reporting Issues

Reporting issues is a great way to became a contributor as it doesn't require technical skills. In fact you don't even need to know a programming language or to be able to check the code itself, you just need to make sure that everything works as expected and [submit an issue report](https://github.com/PaystackHQ/plugin-magento-2/issues/new) if you spot a bug. Sound like something you're up for? Go for it!

#### How To Submit An Issue Report

If something isn't working, congratulations you've found a bug! Help us fix it by submitting an issue report:

* Make sure you have a [GitHub account](https://github.com/signup/free)
* Search the [Existing Issues](https://github.com/PaystackHQ/plugin-magento-2/issues) to be sure that the one you've noticed isn't already there
* Submit a report for your issue
  * Clearly describe the issue (including steps to reproduce it if it's a bug)
  * Make sure you fill in the earliest version that you know has the issue.

### Making Changes

If you believe you have an improvement to the plugin, please feel free to send a pull request so we can review and merge.

#### How To Submit A PR

* Fork the repository on GitHub
* Clone the repository into your local system and create a branch that describes what you are working on by prefixing with `feature/`, `fix/`, `chore/`and so on followed by the title of the fix or feature.
* Make commits that are descriptive and breaks down the process.
* Please **don't** modify the changelog - this will be maintained by Paystack developers.
* Push your fix to the remote version of your branch and create a PR that aims to merge that branch into `master`.

After you follow the step above, the next stage will be waiting on us to merge your Pull Request. We review them all, and make suggestions and changes as and if necessary.

# Additional Resources

* [General GitHub documentation](https://help.github.com/)
* [GitHub pull request documentation](https://help.github.com/articles/about-pull-requests/)
* [Paystack Documentation](https://developers.paystack.co/v2.0/docs/)
* [Paystack Helpdesk](https://paystack.com/help)
