<?php

namespace Meetanshi\SubCategoriesGridList\Block;

use Klarna\Core\Exception;
use Magento\Framework\View\Element\Template;
use Magento\Widget\Block\BlockInterface;
use \Meetanshi\SubCategoriesGridList\Helper\Data;
use \Magento\Backend\Block\Template\Context;
use \Magento\Framework\Registry;
use \Magento\Catalog\Helper\Image;
use \Magento\Catalog\Model\ProductRepository;
use \Magento\Catalog\Model\Category;
use \Magento\Catalog\Model\ResourceModel\Category\CollectionFactory;
use \Magento\Framework\App\Config\ScopeConfigInterface;
use \Magento\Catalog\Model\CategoryFactory;
use \Magento\Store\Model\StoreManagerInterface;


class SubCategory extends Template implements BlockInterface
{
    protected $registry;
    protected $imageHelper;
    protected $category;
    protected $categoryFactory;
    protected $scopeConfig;
    protected $categorydataFactory;
    protected $productRepository;
    protected $_template = "widget/homepage.phtml";
    protected $storeManagerInterface;
    protected $helperData;
    protected $storeManager;

    public function __construct(
        Context $context,
        Registry $registry,
        Image $image,
        ProductRepository $productRepository,
        Category $category,
        CollectionFactory $categoryFactory,
        ScopeConfigInterface $scopeConfig,
        CategoryFactory $categorydataFactory,
        StoreManagerInterface $StoreManagerInterface,
        Data $helperData,
        array $data = []
    ) {
        $this->registry = $registry;
        $this->category = $category;
        $this->categoryFactory = $categoryFactory;
        $this->scopeConfig = $scopeConfig;
        $this->categorydataFactory = $categorydataFactory;
        $this->productRepository = $productRepository;
        $this->imageHelper = $image;
        $this->storeManagerInterface = $StoreManagerInterface;
        $this->helperData = $helperData;
        parent::__construct($context, $data);
    }

    public function getCurrentCategory()
    {
        return $this->registry->registry('current_category');
    }

    public function getCurrentProduct()
    {
        return $this->registry->registry('current_product');
    }

    public function getChildCategoryData($parentcategory)
    {
        $sortBy = $this->helperData->getSortBy();
        $orderBy = $this->helperData->getOrderBy();
        $category = $this->categorydataFactory->create()->load($parentcategory);
        $childrenCategories = $category->getChildrenCategories()->addAttributeToSelect('*')
            ->addAttributeToSort($sortBy, $orderBy);
        return $childrenCategories;
    }

    public function getMaxRow()
    {
        $maxCatPerRow = $this->helperData->getColumnCount();
        return $maxCatPerRow;
    }

    public function getPlaceholderImage()
    {
        $defaultimg = $this->imageHelper->getDefaultPlaceholderUrl('small_image');
        return $defaultimg;
    }

    public function getImageOriginalWidth($product, $imageId, $attributes = [])
    {
        return $this->imageHelper->init($product, $imageId, $attributes)->getWidth();
    }

    public function getImageOriginalHeight($product, $imageId, $attributes = [])
    {
        return $this->imageHelper->init($product, $imageId, $attributes)->getHeight();
    }

    public function getBaseUrl()
    {
        return $this->storeManagerInterface->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_WEB);
        //return parent::getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_WEB); // TODO: Change the autogenerated stub
    }



    public function getCategoryCollection($isActive = true, $level = false, $sortBy = true, $pageSize = false)
    {
        $collection = $this->categoryFactory->create();
        $collection->addAttributeToSelect('*');
        if ($isActive) {
            $collection->addIsActiveFilter();
        }
        if ($level) {
            $collection->addLevelFilter($level);
        }
        if ($sortBy) {
            $collection->addOrderField($sortBy);
        }
        if ($pageSize) {
            $collection->setPageSize($pageSize);
        }
        return $collection;
    }

    public function getCategory($id)
    {
        $categoryData = $this->category->load($id);
        return $categoryData;
    }

    public function getRootCategoryId()
    {
        return $this->storeManagerInterface->getStore()->getRootCategoryId();
    }

    public function getStoreId()
    {
        return $this->storeManagerInterface->getStore()->getId();
    }

    public function getImagePath($imgpath)
    {
        $string = "/pub/media/catalog";
        $position = strpos($imgpath, $string);
        return substr($imgpath, $position);
    }
}
